<?php
/*======================================================================*\
|| #################################################################### ||
|| # DownloadsII 6.0.2 : A downloads mod for vBulletin                # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 by (RS_)Jelle (http://www.minatica.be/)          # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=231427           # ||
|| #################################################################### ||
\*======================================================================*/

class vB_Downloads
{
	var $url;

	function vB_Downloads()
	{
		global $vbulletin, $db;

		$this->url = $vbulletin->options['dl2folderpath'] . '/';

		$this->stats = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl2_main");
	}

	function update_counters()
	{
		$this->update_top_contributors();
		$this->update_latest_files();
		$this->update_popular_files();
	}

	function update_counters_all()
	{
		global $db;

		// clear current category numbers
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_categories SET files = 0");
		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET dl2_uploads = 0, dl2_comments = 0");
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_files SET totalcomments = 0");

		$result = $db->query_read("SELECT DISTINCT(`authorid`) AS authorid FROM " . TABLE_PREFIX . "dl2_comments");
		while ($comment = $db->fetch_array($result))
		{
			$user = $db->query_first("SELECT COUNT(*) AS comments FROM " . TABLE_PREFIX . "dl2_comments WHERE `authorid` = $comment[authorid]");
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET `dl2_comments` = $user[comments] WHERE `userid` = $comment[authorid]");
		}

		$result = $db->query_read("SELECT DISTINCT(`fileid`) AS fileid FROM " . TABLE_PREFIX . "dl2_comments");
		while ($comment = $db->fetch_array($result))
		{
			$file = $db->query_first("SELECT COUNT(*) AS comments FROM " . TABLE_PREFIX . "dl2_comments WHERE `fileid` = $comment[fileid]");
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_files SET `totalcomments` = $file[comments] WHERE `id` = $comment[fileid]");
		}

		// get file loaded information
		$result = $db->query_read("SELECT `uploaderid`, `category` FROM " . TABLE_PREFIX . "dl2_files");
		while ($contrib = $db->fetch_array($result))
		{
			$catid = $contrib['category'];
			$uploaderid = $contrib['uploaderid'];

			$this->modify_filecount($catid, 1);

			$cat = $db->query_first("SELECT COUNT(*) AS filecount FROM " . TABLE_PREFIX . "dl2_files WHERE `uploaderid` = $uploaderid");
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET `dl2_uploads`= $cat[filecount] WHERE `userid`= $uploaderid");
			$db->free_result($cat);
		}

		$db->free_result($result);

		$this->update_top_contributors();
		$this->update_latest_files();
		$this->update_popular_files();

		// update total files count
		$temp = $db->query_first("SELECT COUNT(*) AS `files` FROM " . TABLE_PREFIX . "dl2_files");
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `files` = $temp[files]");

		// update total categories count
		$temp = $db->query_first("SELECT COUNT(*) AS `cats` FROM " . TABLE_PREFIX . "dl2_categories");
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `categories` = $temp[cats]");

		// update total comments count
		$temp = $db->query_first("SELECT COUNT(*) AS `comments` FROM " . TABLE_PREFIX . "dl2_comments");
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `comments` = $temp[comments]");

		$db->free_result($temp);
	}

	function update_latest_files()
	{
		global $db, $stylevar, $vbulletin;

		if ($vbulletin->options['dl2maxlatestfiles'] > 0)
		{
			$statslatestfiles_q = $db->query_read("SELECT `id`, `title` FROM " . TABLE_PREFIX . "dl2_files WHERE `modqueue` = 0 ORDER BY `dateadded` DESC LIMIT " . $vbulletin->options['dl2maxlatestfiles']);
			while ($latest = $db->fetch_array($statslatestfiles_q))
			{
				$dlpanel['name'] = htmlspecialchars_uni(fetch_word_wrapped_string($latest['title'], $vbulletin->options['dl2wordwrap']));
				$dlpanel['id'] = $latest['id'];
				$dlpanel['url'] = $vbulletin->options['bburl'] . "/downloads.php?do=file&amp;id=$dlpanel[id]";

				if ($dlpanel['id'] > 0)
				{
					$templater = vB_Template::create('downloads2_panel_bit');
						$templater->register('dlpanel', $dlpanel);
					$dpanel_latest_bits .= $templater->render();
				}
			}

			$db->free_result($statslatestfiles_q);

			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `latestall` = '" . $db->escape_string($dpanel_latest_bits) . "'");
		}
		else
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `latestall` = ''");
		}
	}

	function update_popular_files()
	{
		global $db, $stylevar, $vbulletin;

		if ($vbulletin->options['dl2maxmostpopularfiles'] > 0)
		{
			$statsmostpopularfiles_q = $db->query_read("SELECT `id`, `title`, `totaldownloads` FROM " . TABLE_PREFIX . "dl2_files WHERE `modqueue` = 0 ORDER BY `totaldownloads` DESC LIMIT " . $vbulletin->options['dl2maxmostpopularfiles']);
			while ($latest = $db->fetch_array($statsmostpopularfiles_q))
			{
				$dlpanel['name'] = htmlspecialchars_uni(fetch_word_wrapped_string($latest['title'], $vbulletin->options['dl2wordwrap']));
				$dlpanel['id'] = $latest['id'];
				$dlpanel['url'] = $vbulletin->options['bburl'] . "/downloads.php?do=file&amp;id=$dlpanel[id]";
				$dlpanel['value'] = vb_number_format($latest['totaldownloads']);

				if ($dlpanel['id'] > 0)
				{
					$templater = vB_Template::create('downloads2_panel_bit');
						$templater->register('dlpanel', $dlpanel);
					$dpanel_popular_bits .= $templater->render();
				}
			}

			$db->free_result($statsmostpopularfiles_q);

			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `popularall` = '" . $db->escape_string($dpanel_popular_bits) . "'");
		}
		else
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `popularall` = ''");
		}
	}

	function update_top_contributors()
	{
		global $db, $stylevar, $vbulletin;

		if ($vbulletin->options['dl2maxtopcontributors'] > 0)
		{
			$statstopcontributers_q = $db->query_read("SELECT `userid`, `username`, `dl2_uploads` FROM " . TABLE_PREFIX . "user WHERE `dl2_uploads` > 0 ORDER BY `dl2_uploads` DESC LIMIT " . $vbulletin->options['dl2maxtopcontributors']);
			while ($latest = $db->fetch_array($statstopcontributers_q))
			{
				$dlpanel['name'] = $latest['username']; // Already cleaned with htmlspecialchars_uni() by default
				$dlpanel['id'] = $latest['userid'];
				// $dlpanel['url'] = $vbulletin->options['bburl'] . "/member.php?u=$dlpanel[id]";
				$dlpanel['url'] = $vbulletin->options['bburl'] . '/' . fetch_seo_url('member', array('userid' => $latest['userid'], 'username' => $latest['username']));
				$dlpanel['value'] = vb_number_format($latest['dl2_uploads']);

				if ($dlpanel['id'] > 0)
				{
					$templater = vB_Template::create('downloads2_panel_bit');
						$templater->register('dlpanel', $dlpanel);
					$dpanel_contrib_bits .= $templater->render();
				}
			}

			$db->free_result($statstopcontributers_q);

			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `contriball` = '" . $db->escape_string($dpanel_contrib_bits) . "'");
		}
		else
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_main SET `contriball` = ''");
		}
	}

	function exclude_cat()
	{
		global $permissions, $vbulletin;

		// check for category permissions
		if ($permissions['excludecatlist'] != '')
		{
			if (($permissions['downloads2permissions'] & $vbulletin->bf_ugp['downloads2permissions']['excludecats']))
			{
				$catexclude = "`id` IN (".$permissions['excludecatlist'].") AND";
			}
			else
			{
				$catexclude = "`id` NOT IN (".$permissions['excludecatlist'].") AND";
			}
		}
		else
		{
			$catexclude = '';
		}

		return $catexclude;
	}

	function exclude_files($multiple = false)
	{
		global $permissions, $vbulletin;

		// check for category permissions
		if ($permissions['excludecatlist'] != '')
		{
			if (($permissions['downloads2permissions'] & $vbulletin->bf_ugp['downloads2permissions']['excludecats']))
			{
				$multiply = ($multiple) ? TABLE_PREFIX . 'dl2_files.' : '' ;
				$filesexclude = "" . $multiply . "category IN (".$permissions['excludecatlist'].") AND";
			}
			else
			{
				$multiply = ($multiple) ? TABLE_PREFIX . 'dl2_files.' : '' ;
				$filesexclude = "" . $multiply . "category NOT IN (".$permissions['excludecatlist'].") AND";
			}
		}
		else
		{
			$filesexclude = '';
		}

		return $filesexclude;
	}

	function build_cat_nav($id)
	{
		if ($id > 0)
		{
			global $db;
			$catexclude = $this->exclude_cat();
			$cat = $db->query_first("SELECT `name`, `id`, `parent` FROM " . TABLE_PREFIX . "dl2_categories WHERE $catexclude `id` = " . $db->sql_prepare($id));
			return $this->build_cat_nav($cat['parent']) + array('downloads.php?' . $vbulletin->session->vars['sessionurl'] . "do=cat&amp;id=$cat[id]" => htmlspecialchars_uni($cat['name']));
		}
		else
		{
			return array();
		}
	}

	function grab_subcats_by_name($id, $depth = 0)
	{
		global $db, $vbulletin;
		if ($vbulletin->options['dl2subcatsdepth'] > $depth)
		{
			// There's no need for a "$vbulletin->options['dl2subcatsdepth'] != 0" check
			$catexclude = $this->exclude_cat();
			$depth++;

			$result = $db->query_read("SELECT `name`, `id` FROM " . TABLE_PREFIX . "dl2_categories WHERE $catexclude `parent` = " . $db->sql_prepare($id) . " ORDER BY `weight`");
			while ($subs = $db->fetch_array($result))
			{
				$subs['name'] = htmlspecialchars_uni($subs['name']);
				$subcats .= '<li><a href="downloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=cat&amp;id=' . $subs['id'] . '">' . $subs['name'] . '</a></li> ' . $this->grab_subcats_by_name($subs['id'], $depth);
			}
		}
		return $subcats;
	}

	function validate_move($start, $destination)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl2_categories WHERE `id` = " . $db->sql_prepare($destination));
		if ($cat['parent'] == 0 OR $cat['parent'] == '')
		{
			return true;
		}
		else if ($cat['parent'] == $start)
		{
			return false;
		}
		else
		{
			return $this->validate_move($start, $cat['parent']);
		}
	}

	function construct_select_array($id = 0, $categories = array(), $spacer = '')
	{
		global $db;
		$catexclude = $this->exclude_cat();
		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl2_categories WHERE $catexclude `parent` = " . $db->sql_prepare($id) . " ORDER BY `weight`");
		while ($category = $db->fetch_array($result))
		{
			$categories += array($category['id'] => $spacer . htmlspecialchars_uni($category['name']));

			if ($category['subs'] > 0)
			{
				$categories += $this->construct_select_array($category['id'], $categories, $spacer . '- ');
			}
		}
		$db->free_result($result);
		return $categories;
	}

	function unset_subcats($id)
	{
		global $db, $categories;
		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl2_categories WHERE `parent` = " . $db->sql_prepare($id));
		if ($db->num_rows($result) > 0)
		{
			while ($cat = $db->fetch_array($result))
			{
				$this->unset_subcats($cat['id']);
			}
		}
		$db->free_result($result);
		unset($categories[$id]);
	}

	function modify_filecount_delete($id, $n = -1)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl2_categories WHERE `id` = " . $db->sql_prepare($id));
		if ($cat['parent'] > 0)
		{
			$this->modify_filecount_delete($cat['parent'], -1);
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_categories SET `files`=`files`+".$n." WHERE `id` = " . $db->sql_prepare($id));
	}

	function modify_filecount($id, $n = 1)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl2_categories WHERE `id` = " . $db->sql_prepare($id));
		if ($cat['parent'] > 0)
		{
			$this->modify_filecount($cat['parent']);
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_categories SET `files`=`files`+".$n." WHERE `id` = " . $db->sql_prepare($id));
	}

	function modify_filecount_user($id)
	{
		global $db;
		$cat = $db->query_first("SELECT COUNT(*) AS filecount FROM " . TABLE_PREFIX . "dl2_files WHERE `uploaderid` = " . $db->sql_prepare($id));
		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET `dl2_uploads` = $cat[filecount] WHERE `userid` = " . $db->sql_prepare($id));
		$db->free_result($cat);
	}

	function modify_subcount($id, $n = 1)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl2_categories WHERE `id` = " . $db->sql_prepare($id));
		if ($cat['parent'] > 0)
		{
			$this->modify_subcount($cat['parent']);
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_categories SET `subs`=`subs`+".$n." WHERE `id` = " . $db->sql_prepare($id));
	}
}

?>